var str_CheckFactoryReset = "Do you want to do the Factory Reset?";
// const maxProfileNumber = 16;

function doFactoryReset() {
    blockUIforPage();
    $.ajax({
        url: "/command/main.cgi?FactoryDefault=hard",
        type: "POST",
        error: function (xhr) {
            UnblockUIforPage();
            console.log("Execute Factory Reset Error");
            alert("Fail to set, please try again");
        },
        success: function (response) {
            console.log("Execute Factory Success");
            setTimeout(function () {
                UnblockUIforPage();
                logout();
            }, 30 * 1000);
        }
    });
}

function updateErrorLog() {
    var errorCode;
    $.ajax({
        url: "/command/inquiry.cgi?inqjs=logconfig",
        type: "GET",
        error: function (xhr) {
            console.log("Get errorlog fail");
        },
        success: function (response) {
            var pcDateNow = {};
            const regEx = /var\s(.*?)\=\"(.*?)\"/gm;
            var result = [];
            while (result = regEx.exec(response)) {
                cameraSettings[result[1]] = result[2];
            }

            errorCode = cameraSettings.ErrorLog0 + "\n" +
                cameraSettings.ErrorLog1 + "\n" +
                cameraSettings.ErrorLog2 + "\n" +
                cameraSettings.ErrorLog3 + "\n" +
                cameraSettings.ErrorLog4 + "\n" +
                cameraSettings.ErrorLog5;
            $("#errorLogTextarea").val(errorCode);
        }
    });
}

function doCleanErrorLog() {
    blockUIforPage();
    $("#errorLogTextarea").val("");
    $.ajax({
        url: "/command/logconfig.cgi?ErrorLog=clean",
        type: "POST",
        error: function (xhr) {
            UnblockUIforPage();
            console.log("Clean Error Log Error");
            alert("Fail to set, please try again");
        },
        success: function (response) {
            //alert("Execute Clean Error Log Success");
            updateErrorLog();
            UnblockUIforPage();
        }
    });
}

var binFile = {};

function updateBinFile(files) {
    console.log("Update firmware bin file path");
    binFile = files[0];
    setTimeout(function () {
        if (binFile !== null) {
            FirmwareUpgradeFirst(binFile);
        }
    }, 50);
}

function FirmwareUpgradeFirst(fileToUpgrade) {
    console.log("FirmwareUpgradeFirst start");
    $('div.NGMark').css('display', 'none');
    //document.getElementById("FirmwareFileUploadBeginWarningMsgDiv").style.display = 'block';

    param = {};
    param.cmd = "fwupdate";
    param.stage = "1st";
    fwUpdateRunning = 1;
    blockUIforPage();
    $.ajax({
        url: "/command/versionup-utils.cgi?VersionUp=setup",
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        data: JSON.stringify(param),
        scriptCharset: "utf-8",
        timeout: 0,
        error: function (xhr) {
            console.log(xhr);
            //document.getElementById("FirmwareFileUploadBeginWarningMsgDiv").style.display = 'none';
            //document.getElementById("FirmwareFileUploadErrorWarningMsgDiv").style.display = 'block';
            showMessageModal("Warning", 'Firmware upgrade failed!!', null);
            UnblockUIforPage();
        },
        success: function (response) {
            console.log(response);
            if (response.STATUS == "OK") {
                console.log("FirmwareUpgradeFirst PASS");
                FirmwareUpgradeSecond(fileToUpgrade);
            }
        }
    });
}

function FirmwareUpgradeSecond(fileToUpgrade) {
    console.log("FirmwareUpgradeSecond start");

    var formdata = new FormData();
    formdata.append('fileupload', fileToUpgrade);
    $.ajax({
        url: "/command/versionup.cgi",
        type: "POST",
        contentType: false,
        processData: false,
        data: formdata,
        error: function (xhr) {},
        timeout: 0,
        error: function (xhr) {
            console.log("FirmwareUpgradeSecond Error");
            //document.getElementById("FirmwareFileUploadBeginWarningMsgDiv").style.display = 'none';
            //document.getElementById("FirmwareFileUploadErrorWarningMsgDiv").style.display = 'block';
            showMessageModal("Warning", 'Firmware upgrade failed!!', null);
            UnblockUIforPage();
        },
        success: function (response) {
            var jsonData = JSON.parse(response);
            if (jsonData.STATUS == "OK") {
                console.log("FirmwareUpgradeSecond PASS");
                var binFileSize = jsonData.FWSIZE;
                if (parseInt(binFileSize, 10) > 0) {
                    console.log("binFileSize : " + binFileSize);
                    FirmwareUpgradeThird(binFileSize);
                }
            } else {
                $('div.NGMark').css('display', 'none');
                //$('#FirmwareFileUploadErrorWarningMsgDiv').css('display', 'block');
                showMessageModal("Warning", 'Firmware upgrade failed!!', null);
                UnblockUIforPage();
            }
        }
    });
}

function FirmwareUpgradeThird(binFileSize) {
    console.log("FirmwareUpgradeThird start");

    //document.getElementById("FirmwareFileUploadBeginWarningMsgDiv").style.display = 'none';
    //document.getElementById("FirmwareFileUploadSuccessWarningMsgDiv").style.display = 'block';

    var options = {};
    param = {};
    param.cmd = "fwupdate";
    param.stage = "3rd";
    param.size = binFileSize.toString();
    $.ajax({
        url: "/command/versionup-utils.cgi?VersionUp=start",
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        data: JSON.stringify(param),
        scriptCharset: "utf-8",
        timeout: 0,
        error: function (xhr) {
            console.log("FirmwareUpgradeThird Error");
            showMessageModal("Warning", 'Firmware upgrade failed!!', null);
            UnblockUIforPage();
        },
        success: function (response) {
            console.log("fwupdate_3rd - finish");
            if (response.STATUS == "NG") {
                console.log("FirmwareUpgradeThird Fail");
                //document.getElementById("FirmwareFileUploadSuccessWarningMsgDiv").style.display = 'none';
                //document.getElementById("FirmwareFileUploadErrorWarningMsgDiv").style.display = 'block';
                showMessageModal("Warning", 'Firmware upgrade failed!!', null);
                UnblockUIforPage();

            } else if (response.STATUS == "OK") {
                console.log("FirmwareUpgradeThird PASS");
                //document.getElementById("FirmwareFileUploadSuccessWarningMsgDiv").style.display = 'none';
                //document.getElementById("FirmwareFileUploadFinishWarningMsgDiv").style.display = 'block';
                showMessageModal("Warning", 'Restart System & Initialization, Please wait 1 minute then refresh web page.', null);
                setTimeout(function () {
                    UnblockUIforPage();
                    logout();
                }, 50 * 1000);
            }
        }
    });
}
var framewidth = 1;

function uploadAction(files) {
    console.log("uploadAction : " + framewidth);
    if (typeof files !== 'undefined') {
        binFile = files[0];
        if ((binFile !== null) && (binFile.name !== null)) {
            document.getElementById("fakeinput_filePath").value = binFile.name.toString();
            $("#upgradeButton").removeClass("disabled").prop("disabled", false);
        } else {
            document.getElementById("fakeinput_filePath").value = "....";
            $("#upgradeButton").addClass("disabled").prop("disabled", true);
        }
    }
}




//var wsUri = "ws://"+location.hostname+":9015";
//var websocket = null;

function initWebSocketMaintenance() {

    if (websocket && websocket.readyState == 1) {

        console.log('Already connection');
        gWebSocketErrorBlockUIPage = false;
        UnblockUIforPage();
        sendMessageMaintenance("GetVideoIsStartStreaming");
        sendMessageMaintenance("GetAllProfile");
        sendMessageIndex("GetCurrentProfileID");
        sendMessageMaintenance("GetNetworkSetting");
        sendMessageMaintenance("GetCurrentProfileID");
        sendMessageIndex("CheckDanteActiveDataIsExport");
    }
    else
    {
        if(gProtocolStr == "http:")
            websocket = new WebSocket( wsUri );
        else
            websocket = new WebSocket( wssUri );
    }
    websocket.addEventListener('open', function() {
        console.log('open connection');
        gWebSocketErrorBlockUIPage = false;
        UnblockUIforPage();
        sendMessageMaintenance("GetVideoIsStartStreaming");
        sendMessageMaintenance("GetAllProfile");
        sendMessageIndex("GetCurrentProfileID");
        sendMessageMaintenance("GetNetworkSetting");
        sendMessageMaintenance("GetCurrentProfileID");
        sendMessageIndex("CheckDanteActiveDataIsExport");
    });

    websocket.addEventListener('message',function(evt)
    {
        if (evt.data instanceof ArrayBuffer && gIsExporting) 
        {
            const now = Date.now();
            if (now - gLastExportDownloadTime < gDownloadCoolDown) return;
            gLastExportDownloadTime = now;
            gIsExporting = false;
            websocket.binaryType = "blob";
            const view = new DataView(evt.data);
            console.log(view.getInt32(0));
            const buffer = view.buffer;
            const blob = new Blob([buffer], { type: 'text/plain' });
            const a = document.createElement('a');
            document.body.appendChild(a);
            a.style = 'display: none';
            const url = window.URL.createObjectURL(blob);
            a.href = url;
            a.download = exportFileName;
            a.click();
            window.URL.revokeObjectURL(url);
            document.body.removeChild(a);
        }
        else if(evt.data instanceof Blob)
        {
                
        } 
        else 
        {
            // text frame
            //console.log('Message received',evt.data);
            //console.log('Message received');
            receivedDataMaintrnance(evt.data);
        }

    });

    websocket.addEventListener('error',function(evt){
        gWebSocketErrorBlockUIPage = true;
        setLoginStatus(false);
        gHadLogin = false;
        clearLoginStatus();
        setTimeout(showWebSocketLost,1000);//blockUIforPage();
    });

    websocket.onclose = function(evt) 
    {
        gWebSocketErrorBlockUIPage = true;
        setLoginStatus(false);
        gHadLogin = false;
        clearLoginStatus();
        setTimeout(showWebSocketLost,1000);//blockUIforPage();
    };


}


function sendMessageMaintenance(cmd,data) {

    var msg = cmd;


    if ( websocket != null )
    {
        //document.getElementById("inputText").value = "";
        //websocket.send( msg );
        var jsonmsg = {};

        jsonmsg.Command = msg;

        if (msg == "LoadProfile") {
            jsonmsg = data;
        }
        else if (msg == "SaveAsProfile") {
            jsonmsg = data;
        }
        else if (msg == "DeleteProfiles") {
            jsonmsg = data;
        }
        //var jsonmsg = {
        //   Command : msg
            //ws_msg : msg//"49.138077,-122.857472"
        //};
        if (websocket.readyState == 1) {
        websocket.send( JSON.stringify(jsonmsg) );
        //console.log( "string sent :", JSON.stringify(jsonmsg) );
        }
        else {
            //do something
            console.log( "websocket.readyState :", websocket.readyState );
            if(websocket.readyState == 3)
            {
                gWebSocketErrorBlockUIPage = true;
                blockUIforPage();
                setLoginStatus(false);
                gHadLogin = false;
                clearLoginStatus();
            }
        }
    }
}


function receivedDataMaintrnance(data) {

    var tempData = data;
    var obj = JSON.parse(tempData); 

    //console.log('obj.Reply:',obj.Reply);

    switch (obj.Reply) {

        case "GetAllProfile":
            updatedProfileList(obj);
            updatedProfileFileTable(obj);
            /* if (gIsVideoStart == 1)
                updateProfilePage(true);
            else
                updateProfilePage(false); */
            updateProfilePage(false);
            break;

        case "GetNetworkSetting":
            currMacTail = getDeviceMac(obj);
            break;

        case "GetStandByStatus":
            updatedGetStandByStatus(obj);
            break;

        case "GetSoundMaxQtyProcessStatus":
            updatedGetSoundMaxQtyProcessStatus(obj);
            break;

        case "DeleteProfiles":
            handleDeleteProfiles(obj);
            break;

        case "GetVideoIsStartStreaming":
            gIsVideoStart = getVideoStreamingStatus(obj);
            break;

        case "StartVideoStreaming":
            updatedStartVideoStreaming(obj,false);
            // updateProfilePage(true);
            updateProfilePage(false);
            break;

        case "StopVideoStreaming":
            updatedStopVideoStreaming(obj);
            updateProfilePage(false);
            break;

        case "GetCurrentProfileID":
            updatedProfileIndex(obj);
            if(isViewerLogin)
            {
                hideViewerBlock(false); 
            }
            else
            {
                hideViewerBlock(true); 
            }
            break;

        case "LoadProfile":
            console.log('LoadProfile!!');
            if("Status" in obj)
            {
                console.log('LoadPorfile Status:',obj.Status);
                if(obj.Status.includes("Finished"))
                {
                    sendMessageMaintenance("GetCurrentProfileID");
                    UnblockUIforPage();
                }
            }
            break;

        case "SearchCamera": //Unblock UI after switching profile
            console.log('SearchCamera result!!');
            sendMessageMaintenance("GetCurrentProfileID");
            UnblockUIforPage();
            break;

        case "CheckDanteActiveDataIsExport":
            updatedCheckDanteActiveDataIsExport(obj);
            break;
    }

}

function GetProfileName(sel) {
    var ProfName = sel.options[sel.selectedIndex].value;

    document.getElementById("ProfileNameTextInput").value = ProfName;
}

function saveAsProfile() {
    var jsonmsg = {};
    var selElm = document.getElementById("SaveProfileSelect");

    jsonmsg.Command = "SaveAsProfile";
    jsonmsg.ID = parseInt(selElm.options[selElm.selectedIndex].text, 10);
    jsonmsg.Name = document.getElementById("ProfileNameTextInput").value ;
    sendMessageMaintenance("SaveAsProfile", jsonmsg);
    sendMessageMaintenance("GetAllProfile");
    sendMessageMaintenance("GetCurrentProfileID");
    document.getElementById("ProfileNameTextInput").value = "";
}

function loadUserProfile() {
    var jsonmsg = {};

    jsonmsg.Command = "LoadProfile";
    jsonmsg.ID = parseInt(document.getElementById("LoadProfileSelect").value, 10);
    sendMessageMaintenance("LoadProfile", jsonmsg);
    sendMessageMaintenance("GetCurrentProfileID");
    blockUIforPage();
}

function updatedProfileList(obj) {
    var i = 0;
    var ProfileFilsLength = obj.ProfileArray.length;

    $("#Select_Profile option").remove();
    $("#LoadProfileSelect option").remove();
    $("#SaveProfileSelect option").remove();
    for (i = 0; i < ProfileFilsLength; i++) {
        $("#Select_Profile").append($("<option></option>").val(obj.ProfileArray[i].ID).text((i+1).toString()+": "+obj.ProfileArray[i].Profile));
        $("#LoadProfileSelect").append($("<option></option>").val(i+1).text((i+1).toString()+". "+obj.ProfileArray[i].Profile));
        $("#SaveProfileSelect").append($("<option></option>").val(obj.ProfileArray[i].Profile).text((i+1).toString()));
    }
}

function openMaintenance() {
    $("#DivMainPage").load("./page/maintenance.html", function () {
        if(!isAuthenticated && !isViewerLogin)
            return;

        window.LanguageManager.InitLanguageOfPage();
        initWebSocketMaintenance();


/*        $("#factoryResetButton").on('click', function () {
            showConfirmationModal("Message", str_CheckFactoryReset, doFactoryReset, null, true);
        });
        $("#cleanErrorLogButton").on('click', function () {
            doCleanErrorLog();
        });
        $("#upgradeButton").on('click', function () {
            if (binFile !== null) {
                FirmwareUpgradeFirst(binFile);
            }
        });*/
        $("#saveProfileButton").on('click', function () {
            $('#ProfileModal').modal('show');
            var selElm = document.getElementById("SaveProfileSelect");
            var optValue = selElm.options[selElm.selectedIndex].value;
            document.getElementById("ProfileNameTextInput").value = optValue;
            /*var table = document.getElementById("profileTbody");
            var currTblCnt = table.rows.length;
            if (currTblCnt < (maxProfileNumber + 1)) {
                $('#ProfileModal').modal('show');
            }
            else
                alert("Reach Max Profiles. Please remove unused profiles then try again.");*/
        });
        $("#BtnProfileSaveCancel").on('click', function () {
            $('#ProfileModal').modal('hide');
        });
        $("#BtnProfileSaveOk").on('click', function () {
            $('#ProfileModal').modal('hide');
            saveAsProfile();
        });

        $("#loadProfileButton").on('click', function () {
            $('#ProfileLoadModal').modal('show');
            // window.LanguageManager.InitLanguageOfPage();
            sendMessageMaintenance("GetAllProfile");
        });
        $("#BtnProfileLoadCancel").on('click', function () {
            $('#ProfileLoadModal').modal('hide');
        });
        $("#BtnProfileLoadOk").on('click', function () {
            $('#ProfileLoadModal').modal('hide');
            loadUserProfile();
        });
        $("#deleteButton").on('click', function () {
            console.log("Click deleteButton ...");
            deleteProfiles();
        });

        document.getElementById("Select_Profile").style.display = "block";
        document.getElementById("Label_Profile").style.display = "block";
    });
}

function onChangeDeleteButton() {
    document.getElementById("deleteButton").disabled = false;
}

function deleteProfiles() {
    var table = document.getElementById("profileTbody");
    var currTblCnt = table.rows.length;
    var tmp_data = [];
    var json_obj = {};
    var jsonmsg = {};
    var idTag = "";
    var state = "";

    console.log("currTblCnt = ", currTblCnt);
    if (currTblCnt <= 1)
        return;

    // go through cells
    for (var i = 1; i < currTblCnt; i++) {
        var tableRow = table.rows[i];
        var rowData = {};
        idTag = "cb_" + i.toString();
        state = document.getElementById(idTag).checked;
        console.log(i, "--", state, "--", tableRow.cells[3].innerText);
        if (state == true) {
            rowData[ "ID" ] = i; // rowData[ "Profile" ] = tableRow.cells[3].innerText;
            tmp_data.push(rowData);
        }
    }
    json_obj[ "ProfileArray" ] = tmp_data;
    console.log(JSON.stringify(json_obj));
    // alert( JSON.stringify(json_obj) );
    jsonmsg.Command = "DeleteProfiles";
    jsonmsg.ProfileArray = tmp_data;
    sendMessageMaintenance("DeleteProfiles", jsonmsg);
}

function handleDeleteProfiles(msg) {
    sendMessageMaintenance("GetAllProfile");
}

function updateProfilePage(status) {
    if (document.getElementById("saveProfileButton")) {
        // Profile Items
        document.getElementById("saveProfileButton").disabled = status;
        document.getElementById("loadProfileButton").disabled = status;
        document.getElementById("deleteButton").disabled = true;
        var table = document.getElementById("profileTbody");
        var currTblCnt = table.rows.length;
        var idTag = "";
        //console.log('currTblCnt :', currTblCnt);
        if (currTblCnt >= 1) {
            for (var i = 1; i < currTblCnt; i++) {
                idTag = "cb_" + i.toString();
                document.getElementById(idTag).disabled = status;
                document.getElementById(idTag).checked = false;
            }
        }
        // Profile Items
    }
    // document.getElementById("Select_Profile").disabled = status;
}

function updatedProfileFileTable(data) {

    var tableData="";

    tableData="<tr class=\"Font_Arial_14_bold\" style=\"width: 832px;\">";
    tableData+="<td class=\"profileTableStyle\" style=\"width: 32px;text-align: center;\">&nbsp;</td>";
    tableData+="<td class=\"profileTableStyle\" style=\"width: 56px;text-align: center;\" id =\"Label_File_Saved_No\">No.</td>";
    tableData+="<td class=\"profileTableStyle\" style=\"width: 240px;padding-left: 8px;\" id =\"Label_File_Saved_Time\">File Saved Time</td>";
    tableData+="<td class=\"profileTableStyle\" style=\"width: 504px;padding-left: 8px;\" id =\"Label_Profile_Name\">Profile Name</td>";
    tableData+="</tr>";

    for(var j=0;j<data.ProfileArray.length;j++){
        tableData+="<tr class=\"Font_Arial_14_white\">";
        for(var i=0;i<4;i++){
            if(i == 0)
                tableData+="<td class=\"profileTableStyle\" style=\"padding-left: 8px; padding-top: 4px;\"><input id=\"cb_"+(j+1)+"\" type=\"checkbox\" class=\"ChkBox-16x16\" onchange=\"onChangeDeleteButton()\"></td>";
            else if(i == 1)
                tableData+="<td class=\"profileTableStyle\" style=\"text-align: center;\"><label style=\"\">"+data.ProfileArray[j].ID+"</label></td>";
            else if(i == 3)
                tableData+="<td class=\"profileTableStyle\" style=\"padding-left: 8px;\">"+data.ProfileArray[j].Profile+"</td>";
            else
                tableData+="<td class=\"profileTableStyle\" style=\"padding-left: 8px;\">"+data.ProfileArray[j].FileSavedTime+"</td>";
        }
        tableData+="</tr>";
    }
    $("#profileTbody").html(tableData);
    if(document.getElementById("deleteButton"))
        document.getElementById("deleteButton").disabled = true;

    window.LanguageManager.InitLanguageOfPage();
}
